@echo off
:: https://privacy.sexy — v0.13.8 — Sat, 11 Oct 2025 16:24:24 GMT
:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: ----------------------------------------------------------
:: -------Remove outdated "Snipping Tool" app (revert)-------
:: ----------------------------------------------------------
echo --- Remove outdated "Snipping Tool" app (revert)
:: Reinstall 'Microsoft.ScreenSketch' if it was previously uninstalled
PowerShell -ExecutionPolicy Unrestricted -Command "$packageName='Microsoft.ScreenSketch'; $publisherId='8wekyb3d8bbwe'; if (Get-AppxPackage -Name $packageName) { Write-Host "^""Skipping, `"^""$packageName`"^"" is already installed for the current user."^""; exit 0; }; Write-Host "^""Starting the installation process for `"^""$packageName`"^""..."^""; <# Attempt installation using the manifest file #>; Write-Host "^""Checking if `"^""$packageName`"^"" is installed on another user profile..."^""; $packages = @(Get-AppxPackage -AllUsers $packageName); if (!$packages) { Write-Host "^""`"^""$packageName`"^"" is not installed on any other user profiles."^""; } else { foreach ($package in $packages) { Write-Host "^""Found package `"^""$($package.PackageFullName)`"^""."^""; $installationDir = $package.InstallLocation; if ([string]::IsNullOrWhiteSpace($installationDir)) { Write-Warning "^""Installation directory for `"^""$packageName`"^"" is not found or invalid."^""; continue; }; $manifestPath = Join-Path -Path $installationDir -ChildPath 'AppxManifest.xml'; try { if (-Not (Test-Path "^""$manifestPath"^"")) { Write-Host "^""Manifest file not found for `"^""$packageName`"^"" on another user profile: `"^""$manifestPath`"^""."^""; continue; }; } catch { Write-Warning "^""An error occurred while checking for the manifest file: $($_.Exception.Message)"^""; continue; }; Write-Host "^""Manifest file located. Trying to install using the manifest: `"^""$manifestPath`"^""..."^""; try { Add-AppxPackage -DisableDevelopmentMode -Register "^""$manifestPath"^"" -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its manifest file."^""; exit 0; } catch { Write-Warning "^""Error installing from manifest: $($_.Exception.Message)"^""; }; }; }; <# Attempt installation using the package family name #>; $packageFamilyName = "^""$($packageName)_$($publisherId)"^""; Write-Host "^""Trying to install `"^""$packageName`"^"" using its package family name: `"^""$packageFamilyName`"^"" from system installation..."^""; try { Add-AppxPackage -RegisterByFamilyName -MainPackage $packageFamilyName -ErrorAction Stop; Write-Host "^""Successfully installed `"^""$packageName`"^"" using its package family name."^""; exit 0; } catch { Write-Warning "^""Error installing using package family name: $($_.Exception.Message)"^""; }; throw "^""Unable to reinstall the requested package ($packageName). "^"" + "^""It appears to no longer be included in this version of Windows. "^"" + "^""You may search for it or an alternative in the Microsoft Store or "^"" + "^""consider using an earlier version of Windows where this package was originally provided."^"""
:: Remove 'Microsoft.ScreenSketch' from deprovisioned list to allow reinstall during updates.
:: Restore "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.ScreenSketch_8wekyb3d8bbwe" registry key by deleting it
PowerShell -ExecutionPolicy Unrestricted -Command "$keyPath='HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Appx\AppxAllUserStore\Deprovisioned\Microsoft.ScreenSketch_8wekyb3d8bbwe'; $registryHive = $keyPath.Split('\')[0]; $registryPath = "^""$($registryHive):$($keyPath.Substring($registryHive.Length))"^""; Write-Host "^""Removing registry key at `"^""$registryPath`"^""."^""; if (-not (Test-Path -LiteralPath $registryPath)) { Write-Host "^""Skipping, no action needed, registry key `"^""$registryPath`"^"" does not exist."^""; exit 0; }; try { Remove-Item -LiteralPath $registryPath -Force -ErrorAction Stop | Out-Null; Write-Host "^""Successfully removed the registry key at path `"^""$registryPath`"^""."^""; } catch { Write-Error "^""Failed to remove the registry key at path `"^""$registryPath`"^"": $($_.Exception.Message)"^""; }"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---------Disable outdated Snipping Tool (revert)----------
:: ----------------------------------------------------------
echo --- Disable outdated Snipping Tool (revert)
:: Delete the registry value "HKLM\SOFTWARE\Policies\Microsoft\TabletPC!DisableSnippingTool"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Policies\Microsoft\TabletPC' /v 'DisableSnippingTool' /f 2>$null"
:: ----------------------------------------------------------


:: Disable Snipping Tool keyboard shortcut (**Windows logo key** + **Shift** + **S**) (revert)
echo --- Disable Snipping Tool keyboard shortcut (**Windows logo key** + **Shift** + **S**) (revert)
:: Restore the global Windows hotkey "S" to re-enable its default functionality.
PowerShell -ExecutionPolicy Unrestricted -Command "$keyToRestore='S'; $keyToRestoreInUppercase = $keyToRestore.ToUpper(); $registryPath = 'HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced'; $propertyName = 'DisabledHotkeys'; $disabledKeys = Get-ItemProperty -Path $registryPath -Name $propertyName -ErrorAction SilentlyContinue | Select-Object -ExpandProperty "^""$propertyName"^""; if (-Not $disabledKeys) { Write-Host "^""Skipping: No keys has been disabled before, no need to restore `"^""$keyToRestoreInUppercase`"^""."^""; Exit 0; }; if (-Not $disabledKeys.Contains($keyToRestoreInUppercase)) { Write-Host "^""Skipping: Key `"^""$keyToRestoreInUppercase`"^"" is not disabled. All disabled keys: `"^""$disabledKeys`"^"". No action needed."^""; Exit 0; }; $newKeysToDisable = $disabledKeys.Replace($keyToRestoreInUppercase, "^"""^""); if (-Not $newKeysToDisable) { Write-Host "^""Removing all entries from the disabled keys as the last key `"^""$keyToRestoreInUppercase`"^"" is being restored."^""; try { Remove-ItemProperty -Path $registryPath -Name $propertyName -Force -ErrorAction Stop; Write-Host "^""Successfully removed the `"^""$propertyName`"^"" property from the registry, no disabled keys remain."^""; Exit 0; } catch { Write-Error "^""Failed to remove the empty `"^""$propertyName`"^"" property from the registry: $_"^""; Exit 1; }; }; try { Write-Host "^""Restoring `"^""$keyToRestoreInUppercase`"^"", all disabled keys: `"^""$disabledKeys`"^"", new disabled keys: `"^""$newKeysToDisable`"^""."^""; Set-ItemProperty -Path $registryPath -Name $propertyName -Value "^""$newKeysToDisable"^"" -Force -ErrorAction Stop; Write-Host "^""Successfully restored `"^""$keyToRestoreInUppercase`"^"", disabled keys now: `"^""$newKeysToDisable`"^""."^""; Exit 0; } catch { Write-Error "^""Failed to restore `"^""$keysToDisable`"^"": $_"^""; Exit 1; }"
:: Suggest restarting explorer.exe for changes to take effect
PowerShell -ExecutionPolicy Unrestricted -Command "$message = 'This script will not take effect until you restart explorer.exe. You can restart explorer.exe by restarting your computer or by running following on command prompt: `taskkill /f /im explorer.exe & start explorer`.'; $warn =  $false; if ($warn) { Write-Warning "^""$message"^""; } else { Write-Host "^""Note: "^"" -ForegroundColor Blue -NoNewLine; Write-Output "^""$message"^""; }"
:: ----------------------------------------------------------


:: Disable Print Screen keyboard shortcut for Snipping Tool (revert)
echo --- Disable Print Screen keyboard shortcut for Snipping Tool (revert)
:: Delete the registry value "HKCU\Control Panel\Keyboard!PrintScreenKeyForSnippingEnabled"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKCU\Control Panel\Keyboard' /v 'PrintScreenKeyForSnippingEnabled' /f 2>$null"
:: Suggest restarting explorer.exe for changes to take effect
PowerShell -ExecutionPolicy Unrestricted -Command "$message = 'This script will not take effect until you restart explorer.exe. You can restart explorer.exe by restarting your computer or by running following on command prompt: `taskkill /f /im explorer.exe & start explorer`.'; $warn =  $false; if ($warn) { Write-Warning "^""$message"^""; } else { Write-Host "^""Note: "^"" -ForegroundColor Blue -NoNewLine; Write-Output "^""$message"^""; }"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0